#ifndef CWYKRES3D_H
#define CWYKRES3D_H

#include "colormaps.h"
#include "oknogl.h"
#include "gridparam.h"

#define ROZMIAR_BUFORA_SELEKCJI 64

#define PARAM_ERROR   0x0000
#define PARAM_END     0x0001
#define PARAM_XRANGE  0x0002
#define PARAM_YRANGE  0x0003
#define PARAM_SCALE   0x0004
#define PARAM_EVERY   0x0005
#define PARAM_PALETTE 0x0006
#define PARAM_TYPE    0x0007
#define PARAM_MOD_PSI 0x0008
#define PARAM_COLOR   0x0009

typedef struct {
    float psi_value;
    rgb_triplet kolor;
} fpsi;

typedef fpsi* pfpsi;

class CWykres3D : public COknoGL
{
	private:

		short int paleta, typ,  every;
		double skala, Xmin, Xmax, Ymin, Ymax, wsp;
		bool mod_psi;
		rgb_triplet kolor;

		double  minpsi, //warto minimalna
				maxpsi, //warto maksymalna
				_min,   //minimalny kwadrat wartoci
				_max,   //maksymalny kwadrat wartoci
				min_value, //warto minimalna uwzgldniajaca zmienne skala i mod_psi
				max_value; //warto maksymalna uwzgldniajaca zmienne skala i mod_psi

		int imin, imax, jmin, jmax;
		double x_sr, y_sr;

		int error;

		fpsi **psi;
		GridParam *gp;

		int Parametr(char *parametr);
		int CzytajParametryProgramu(char *plikKonfiguracyjny);
		int CzytajParametrySieci(char *nazwaPliku);
		int CzytajDane(const char *nazwaPliku);
		void UstawIJZakres();
		void MinMax2D();
		void UstawSkale();

		rgb_triplet Kolor(double minpsi, double maxpsi, double psi);
		void UstawKolor();

		void RysujPsiPunkty();
		void RysujPsiImpulsy();
		void RysujPsiLinie();
		void RysujPsiPowierzchnia();
		void RysujOsie();
		void UstawOpis(int czcionka);

		float lposX, lposY, lposZ;

		int SelekcjaObiektow(unsigned int  buforSelekcji[ROZMIAR_BUFORA_SELEKCJI], int xPos, int yPos);
		void RysujLampe(int NrLight, float x, float y, float z);

		virtual LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam);

		int list_id, NRWybranegoObiektu, ileTrafien, czcionka;

		void RysujAktorow();
		void ZrodlaSwiatla();

	public:
		 CWykres3D();
		~CWykres3D();

} wykres3D;

COknoGL* p_okno=&wykres3D;

#endif //CWYKRES3D_H